//+------------------------------------------------------------------+
//|                                                   C_Controls.mqh |
//|                                                      Daniel Jose |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#include <Market Replay\Interprocess.mqh>
//+------------------------------------------------------------------+
#define def_ButtonPlay 	"Images\\Market Replay\\Play.bmp"
#define def_ButtonPause	"Images\\Market Replay\\Pause.bmp"
#resource "\\" + def_ButtonPlay
#resource "\\" + def_ButtonPause
//+------------------------------------------------------------------+
#define def_PrefixObjectName "Market Replay _ "
//+------------------------------------------------------------------+
class C_Controls
{
	private	:
//+------------------------------------------------------------------+
		string	m_szBtnPlay;
		long		m_id;
//+------------------------------------------------------------------+
		void CreateBtnPlayPause(long id)
			{
				m_szBtnPlay = def_PrefixObjectName + "Play";
				ObjectCreate(id, m_szBtnPlay, OBJ_BITMAP_LABEL, 0, 0, 0);
				ObjectSetInteger(id, m_szBtnPlay, OBJPROP_XDISTANCE, 5);
				ObjectSetInteger(id, m_szBtnPlay, OBJPROP_YDISTANCE, 25);
				ObjectSetInteger(id, m_szBtnPlay, OBJPROP_STATE, false);
				ObjectSetString(id, m_szBtnPlay, OBJPROP_BMPFILE, 0, "::" + def_ButtonPause);
				ObjectSetString(id, m_szBtnPlay, OBJPROP_BMPFILE, 1, "::" + def_ButtonPlay);
			}
//+------------------------------------------------------------------+
	public	:
//+------------------------------------------------------------------+
		C_Controls()
			{
				m_szBtnPlay = NULL;
			}
//+------------------------------------------------------------------+
		~C_Controls()
			{
				ObjectDelete(ChartID(), m_szBtnPlay);
			}		
//+------------------------------------------------------------------+
		void Init(void)
			{
				if (m_szBtnPlay != NULL) return;
				CreateBtnPlayPause(m_id = ChartID());
				GlobalVariableTemp(def_GlobalVariableReplay);
				ChartRedraw();
			}
//+------------------------------------------------------------------+
		void DispatchMessage(const int id, const long &lparam, const double &dparam, const string &sparam)
			{
				u_Interprocess Info;
				
				switch (id)
				{
					case CHARTEVENT_OBJECT_CLICK:
						if (sparam == m_szBtnPlay)
						{
							Info.s_Infos.isPlay = (bool) ObjectGetInteger(m_id, m_szBtnPlay, OBJPROP_STATE);
							GlobalVariableSet(def_GlobalVariableReplay, Info.Value);
						}
						break;
				}
			}
//+------------------------------------------------------------------+
};
//+------------------------------------------------------------------+
#undef def_ButtonPlay
#undef def_ButtonPause
//+------------------------------------------------------------------+
